
// author: RuanShengQiang 
// date: 2017/6/21
#define vec2 float2
#define vec3 float3
#define vec4 float4
#define rgb xyz
#define rgba xyzw
#define PI 3.141592653589f

const sampler_t sampler = CLK_NORMALIZED_COORDS_TRUE | CLK_ADDRESS_CLAMP_TO_EDGE | CLK_FILTER_LINEAR;
__constant float MIN_AMOUNT = -0.16f;
__constant float MAX_AMOUNT = 1.3f;
__constant const float scale = 512.0f;
__constant const float sharpness = 3.0f;
__constant const float cylinderRadius = 1.0f / PI / 2.0f;

vec3 hitPoint(float hitAngle, float yc, vec3 point, float3* rrotation)
{
	float hitPoint = hitAngle / (2.0f * PI);
	point.y = hitPoint;
	vec3 ret;
	ret.x = dot( rrotation[0], point);
	ret.y = dot( rrotation[1], point);
	ret.z = dot( rrotation[2], point);
	return ret;
}

vec4 antiAlias(vec4 color1, vec4 color2, float distanc)
{
	distanc *= scale;
	if (distanc < 0.0f) return color2;
	if (distanc > 2.0f) return color1;
	float dd = pow(1.0f - distanc / 2.0f, sharpness);
	return ((color2 - color1) * dd) + color1;
}

float _abs(float a)
{
	if(a<0.0f)
		return -a;
	else
		return a;
}

vec4 INPUT(image2d_t src_data, __global FilterParam* param, vec2 tc)
{
	tc = (vec2)(tc.x, tc.y)*(vec2)(param->origROI[2], param->origROI[3]) + (vec2)(param->origROI[0], param->origROI[1]);
	return read_imagef(src_data, sampler, (vec2)(tc.x, 1.0f - tc.y));
}

float distanceToEdge(vec3 point)
{
	float dx = fabs(point.x > 0.5f ? 1.0f - point.x : point.x);
	float dy = fabs(point.y > 0.5f ? 1.0f - point.y : point.y);
	if (point.x < 0.0f) dx = -point.x;
	if (point.x > 1.0f) dx = point.x - 1.0f;
	if (point.y < 0.0f) dy = -point.y;
	if (point.y > 1.0f) dy = point.y - 1.0f;
	if ((point.x < 0.0f || point.x > 1.0f) && (point.y < 0.0f || point.y > 1.0f)) return sqrt(dx * dx + dy * dy);
	return fmin(dx, dy);
}

vec4 seeThrough(float yc, vec2 p, float3* rotation, float3* rrotation, vec2 gl_FragCoord, vec2 iResolution, __read_only image2d_t input1, __read_only image2d_t input2, float cylinderAngle, __global FilterParam* param)
{
	float hitAngle = PI - (acos(yc / cylinderRadius) - cylinderAngle);
	vec3 temp ;
	vec3 mulEl = (vec3)(p, 1.0f) ;
	temp.x = dot( rotation[0], mulEl);
	temp.y = dot( rotation[1], mulEl);
	temp.z = dot( rotation[2], mulEl);
	
	vec3 point = hitPoint(hitAngle, yc, temp, rrotation);
	
	if (yc <= 0.0f && (point.y > 0.0f && point.y < 0.008f))
    {
        vec2 texCoord = gl_FragCoord.xy / iResolution.xy;
        float a = 1.0f;
        a = 1.0f - smoothstep(0.0f, 0.008f, point.y);
        return mix(INPUT(input1, param, point.xy), INPUT(input2, param, texCoord), a);
    }
	
    if (yc <= 0.0f && ( point.x > 0.999f && point.x < 1.0f))
	{
        vec2 texCoord = gl_FragCoord.xy / iResolution.xy;
        float a = 1.0f;
        a = 1.0f - smoothstep(0.999f, 1.0f, point.y);
	    return mix(INPUT(input1, param, point.xy), INPUT(input2, param, texCoord), a);
	}
	
	if (yc <= 0.0f && (point.x < 0.0f || point.y < 0.0f || point.x > 1.0f || point.y > 1.0f))
	{
		vec2 texCoord = gl_FragCoord.xy / iResolution.xy;
		return INPUT(input2, param, texCoord);
	}

	if (yc > 0.0f) return INPUT(input1, param, p);

	vec4 color = INPUT(input1, param, point.xy);
	vec4 tcolor = (vec4)(0.0f);

	return antiAlias(color, tcolor, distanceToEdge(point));
}

vec4 seeThroughWithShadow(float yc, vec2 p, vec3 point, float3* rotation, float3* rrotation,
							vec2 gl_FragCoord, vec2 iResolution, __read_only image2d_t input1,__read_only image2d_t input2, float  amount, float cylinderAngle, __global FilterParam* param)
{
	float shadow = distanceToEdge(point) * 30.0f;
	shadow = (1.0f - shadow) / 3.0f;

	if (shadow < 0.0f) shadow = 0.0f; else shadow *= amount;
	
	vec4 shadowColor = seeThrough(yc, p, rotation, rrotation, gl_FragCoord, iResolution, input1, input2, cylinderAngle, param);
	//shadowColor.x -= shadow;
	//shadowColor.y -= shadow;
	//shadowColor.z -= shadow;

	return (vec4)(shadowColor);
}

vec4 backside(float yc, vec3 point,__read_only image2d_t input1, __global FilterParam* param )
{
	vec4 color = INPUT(input1, param, point.xy);
	float gray = (color.z + color.y + color.x) / 15.0f;
	gray += (8.0f / 10.0f) * (pow(1.0f - _abs(yc / cylinderRadius), 2.0f / 10.0f) / 2.0f + (5.0f / 10.0f));
	color.rgb = (vec3)(gray);
	return color;
}

vec4 behindSurface(float ycInput, vec3 point, float3* rrotation,vec2 texCoord, float amount,float cylinderAngle, __read_only image2d_t input2, __global FilterParam* param )
{
	float shado = (1.0f - ((-cylinderRadius - ycInput) / amount * 7.0f)) / 6.0f;
	shado *= 1.0f - fabs(point.x - 0.5f);

	float yc = (-cylinderRadius - cylinderRadius - ycInput);

	float hitAngle = (acos(yc / cylinderRadius) + cylinderAngle) - PI;
	point = hitPoint(hitAngle, yc, point, rrotation);

	if (yc < 0.0f && point.x >= 0.0f && point.y >= 0.0f && point.x <= 1.0f && point.y <= 1.0f && (hitAngle < PI || amount > 0.5f))
	{
		shado = 1.0f - (sqrt(pow(point.x - 0.5f, 2.0f) + pow(point.y - 0.5f, 2.0f)) / (71.0f / 100.0f));
		shado *= pow(-yc / cylinderRadius, 3.0f);
		shado *= 0.5f;
	}
	else
	{
		shado = 0.0f;
	}

	return (vec4)(INPUT(input2, param, texCoord).rgb - shado, 1.0f);
}


float rand(vec2 co){
	float temp; 
	return fract(sin(dot(co.xy ,(vec2)(12.9898f,78.233f))) * 43758.5453f,&temp);
}

__kernel void MAIN(__read_only image2d_t input1, __read_only image2d_t input2, __write_only image2d_t dstImg,__global FilterParam* param)
{
	float progress = param->cur_time / param->total_time;
	int W = get_global_size(0);
	int H = get_global_size(1);
	int textH = param->height[2];
	int w = get_global_id(0);
	int h = get_global_id(1);
	float2 iResolution = (float2)(W,H);
	//int2 gl_FragCoord = (int2)(get_global_id(0), get_global_id(1));
	vec2 gl_FragCoord = (vec2)(get_global_id0( param), get_global_id1( param));
	vec2 uv = (vec2)(gl_FragCoord.x, gl_FragCoord.y)/iResolution.xy;
	vec2 tempUV = uv;

	float iGlobalTime = progress;
	const float sampleSize = 32.0f;
	const int Samples = 16;//multiple of 2
	
	float amount = progress * (MAX_AMOUNT - MIN_AMOUNT) + MIN_AMOUNT;
	float cylinderAngle = 2.0f * PI * amount;
	float cylinderCenter = amount;
	
	
	vec2 texCoord = uv;
  
	const float angle = 30.0f * PI / 180.0f;
	float c = cos(-angle);
	float s = sin(-angle);
/*
	vec3 rotation[3] = { (vec3)(c, s, 0.0f),
						(vec3)(-s, c, 0.0f),
						(vec3)(0.12f, 0.258f, 1.0f)
					};
*/					
	vec3 rotation[3] = { (vec3)(c, -s, 0.12f),
						(vec3)(s, c, 0.258f),
						(vec3)(0.0f, 0.0f, 1.0f)
					};
					
					
	c = cos(angle);
	s = sin(angle);
/*
	vec3 rrotation[3] = { (vec3)(c, s, 0.0f),
						(vec3)(-s, c, 0.0f),
						(vec3)(0.15f, -0.5f, 1.0f)
					};
*/					
	vec3 rrotation[3] = { (vec3)(c, -s, 0.15f),
						  (vec3)(s, c, -0.5f),
						  (vec3)(0.0f, 0.0f, 1.0f)
					};
					
	vec3 point;
	vec3 tempMult = (vec3)(texCoord, 1.0f);
	
	point.x = dot( rotation[0], tempMult);
	point.y = dot( rotation[1], tempMult);
	point.z = dot( rotation[2], tempMult);

	float yc = point.y - cylinderCenter;

	if (yc < -cylinderRadius)
	{
		// Behind surface
		//behindSurface(float yc, vec3 point, float3* rrotation,vec2 texCoord, float amount,float cylinderAngle, __read_only image2d_t input2)
		
		vec4 col = behindSurface(yc, point, rrotation,uv, amount,cylinderAngle, input2, param);
		write_imagef(dstImg, (int2)(w, textH - h -1), col);
		return ;
	}
	

	if (yc > cylinderRadius)
	{
		// Flat surface
		write_imagef(dstImg, (int2)(w, textH - h -1), INPUT(input1, param, texCoord));
		return ;
	}
	
	float hitAngle = (acos(yc / cylinderRadius) + cylinderAngle) - PI;

	float hitAngleMod = fmod(hitAngle, 2.0f * PI);
	if ((hitAngleMod > PI && amount < 0.5f) || (hitAngleMod > PI/2.0f && amount < 0.0f))
	{
		write_imagef(dstImg, (int2)(w, textH - h -1), seeThrough(yc, texCoord, rotation, rrotation, gl_FragCoord, iResolution, input1, input2, cylinderAngle, param));
		return ;
	}
	

	point = hitPoint(hitAngle, yc, point, rrotation);

	if (point.x < 0.0f || point.y < 0.0f || point.x > 1.0f || point.y > 1.0f)
	{
		
		vec4 col = seeThroughWithShadow(yc, texCoord, point, rotation, rrotation, gl_FragCoord, iResolution, input1, input2, amount, cylinderAngle, param);
		write_imagef(dstImg, (int2)(w, textH - h -1),col);
		return;
	}
//write_imagef(dstImg,  (int2)(w, H - h -1), (vec4)(point, 1.0f));

	vec4 color = backside(yc, point, input1, param);

	vec4 otherColor;
	if (yc < 0.0f)
	{
		float shado = 1.0f - (sqrt(pow(point.x - 0.5f, 2.0f) + pow(point.y - 0.5f, 2.0f)) / 0.71f);
		shado *= pow(-yc / cylinderRadius, 3.0f);
		shado *= 0.5f;
		otherColor = (vec4)(0.0f, 0.0f, 0.0f, shado);
	}
	else
	{
		otherColor = INPUT(input1, param, texCoord);
	}

	color = antiAlias(color, otherColor, cylinderRadius - fabs(yc));

	vec4 cl = seeThroughWithShadow(yc, texCoord, point, rotation, rrotation, gl_FragCoord, iResolution, input1, input2, amount, cylinderAngle, param);
	float dist = distanceToEdge(point);

	write_imagef(dstImg,  (int2)(w, textH - h -1), antiAlias(color, cl, dist));

}